# Introduction -----

#In this script we do three things

# - Correlation plots for the 12 sleep EEG variables 
# - Relationships between the 12 sleep variables and various behavioural/hypnographic parameters
# - Correlations on the behavioural/hypno variables?


# - We calculate the mediation models

# Set up ----

## Load packages and metadata ---------

#Load packages
pacman::p_load(tidyverse,patchwork,ghibli,eegUtils,emmeans,lme4,broom.mixed,gtsummary)


#Get our default settings
source("./eLife Submission Scripts/Analysis-Common-Utilities.R")


## Load EEG data ----- 

d_gamm = read_rds("./eLife Submission Data/sleep_study_eeg_summary_data_z.rds")

#Remove the angle data as we are not using it for mediation
d_gamm = 
  d_gamm |>
  filter(measure != "itpc_overlap_angle")


# Mediation of psychiatric/behavioural measures by EEG measures ======


#Use mediation analysis to ask if the effect of genotype on psychiatric symptoms/IQ is mediated by EEG measures

#Use a subset of measures based on our results
eeg_measures = c("cons_REM","spin_amp","so_amp","itpc_overlap_mag_z")

#Select psychiatric measures to use
psych_measures = c("sleepprobsall","asqtotalsymsall","anyanxsymsall","adhdsymsall","pesall","fsiqall")

#We need to work out the variable types
vars_count = c("sleepprobsall","asqtotalsymsall","anyanxsymsall","adhdsymsall")
vars_cont  = c("fsiqall",
               "tst_eeg","se_eeg","waso_eeg",
               "latencyn1_eeg","latencyrem_eeg",
               "percnightn1_eeg","percnightn2_eeg","percnightn3_eeg","percnightrem_eeg",
               "cons_REM","cons","spin_amp","so_amp","itpc_overlap_mag_z")
vars_bern = "pesall"


#Prepare the datasets
d_med_eeg_60 = 
  d_gamm |>
  filter(measure %in% eeg_measures | (measure == "cons" & stage == "REM") ) |>
  unnest(cols = c(data)) |>
  ungroup() |>
  rename("mediator_value" = "value", "mediator" = "measure") |>
  left_join(meta |> select(subject, all_of(psych_measures)),by = "subject") |>
  dplyr::select(subject,group,family,gender, mediator,electrode,mediator_value,age_eeg,all_of(psych_measures)) |> 
  pivot_longer(all_of(psych_measures)   , names_to = "outcome"   , values_to = "outcome_value") |>
  drop_na() |>
  mutate(electrode = factor(electrode),
         subject   = factor(subject),
         group     = factor(group,levels = c("Sib", "22q"))) |>
  group_by(electrode,mediator,outcome) |>
  nest()


#Fit mediation models for all electrodes, eeg measures and psychiatric/cognitive measures

#Set mediator variable types
d_med_eeg_60 =
  d_med_eeg_60 |>
  mutate(med_type = map_chr(mediator, ~ifelse(.x %in% vars_count,"count",ifelse(.x %in% vars_cont,"continuous","bernoulli"))),
         out_type = map_chr(outcome , ~ifelse(.x %in% vars_count,"count",ifelse(.x %in% vars_cont,"continuous","bernoulli"))))

d_m = 
  d_med_eeg_60 |>
  unnest(data) |>
  ungroup() |>
  group_by(outcome,mediator) |>
  nest()


#Do as a loop to catch bugs - Takes a long time
d_m$clus = vector(mode = "list", length = nrow(d_m))

for(i in 1:nrow(d_m)){
  
  d_m$clus[[i]] = cluster_correct_mediation(d_m$data[[i]],
                                            neighbours = d_neighbours,
                                            group_var = "electrode",
                                            totperm = 500,
                                            clus_alpha = 0.025, 
                                            montecarlo_alpha = 0.05)
}


## Save mediation models =======

#This is the full data
readr::write_rds(d_m,"./Data/sleep_study_mediation_models.rds")


## Prepare plotting data ======

#This is how we prepare plotting summary data
d_m = 
  readr::read_rds("./Data/sleep_study_mediation_models.rds")

d_clus = 
  d_m |>
  select(-data) |>
  ungroup() |>
  unnest(clus)

d_clus  =
  d_clus |>
  unnest(data) |>
  dplyr::select(-c(neighbours,perm_coefs)) |>
  group_by(mediator,outcome,Term,clus) |>
  nest() |> 
  ungroup() |>
  group_by(mediator,outcome) |>
  nest() |>
  rename(clus = data)


d_m_plot  =
  d_m |>
  ungroup() |>
  dplyr::select(-c(clus)) |>
  left_join(d_clus,by = c("mediator","outcome"))


readr::write_rds(d_m_plot,"./elife Submission Data/sleep_study_mediation_plot.rds")
